/*
 * Decompiled with CFR 0.152.
 */
package inputstatus;

import LinuxCommandExecutor.LinuxCommandExecutor;
import entity.Channels;
import entity.Input;
import entityDB.InputDB;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class InputStatus {
    static BufferedWriter bw;
    static String filePath;
    static String client;
    static InputDB inputdb;

    public static void main(String[] args) {
        try {
            client = new InputDB().getClient();
            while (true) {
                InputStatus.inputMethod("file");
            }
        }
        catch (Exception e) {
            System.err.println("Exception in main: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamStatus() {
        try {
            List<Channels> channellist = inputdb.getChannelsAll();
            for (Channels obj : channellist) {
                boolean result = false;
                try {
                    URL url = new URL("http://" + obj.getServerip() + "/pid/stream" + obj.getId() + "-pid");
                    URLConnection c = url.openConnection();
                    c.connect();
                    c.setReadTimeout(1000);
                    InputStream is = c.getInputStream();
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
                    String line = "";
                    String output = "";
                    while ((line = dis.readLine()) != null) {
                        System.out.println("line for stream status : " + line);
                        output = output + line;
                    }
                    if (output != null) {
                        result = true;
                    }
                    System.out.println(obj.getChannelname());
                    System.out.println(result);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    inputdb.updateStreamStatus(result, obj.getId());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void inputMethod(String methodname) throws InterruptedException, ClassNotFoundException {
        List<Input> inputList = inputdb.getActiveInputsIPTV(methodname);
        String path = "/home/user/RIDSYSPACKAGE/riptv/live/INPUTSTATUS/RStream";
        if (methodname.equalsIgnoreCase("ffprobe")) {
            for (Input i : inputList) {
                InputStatus.inputReadForffprobe(i.getUdp(), i.getId(), i.getServer_ip(), i.getStreamcount());
                Thread.sleep(2000L);
            }
        } else {
            if (client.equalsIgnoreCase("E2 INFO SOLUTIONS")) {
                System.out.println("client e2info came");
                List<Map<String, Object>> secServers = inputdb.getServers();
                for (Map<String, Object> server : secServers) {
                    try {
                        boolean instatus = false;
                        boolean outstatus = false;
                        if (!server.get("input_eth").toString().equalsIgnoreCase("None")) {
                            instatus = server.get("remark").toString().equalsIgnoreCase("primary") ? LinuxCommandExecutor.interfaceStatus(server.get("input_eth").toString()) : InputStatus.secondaryInterfaceSatus(server.get("serverip").toString(), server.get("input_eth").toString());
                            if (instatus) {
                                List<Input> inputlist = inputdb.getInputByServerIp(server.get("serverip").toString());
                                for (Input i : inputlist) {
                                    String protocol = InputStatus.getProtocolType(i.getUdp());
                                    boolean result = InputStatus.primaryInputStatus(path, protocol, i.getUdp());
                                    inputdb.updateStreamInputStatus(i.getId(), result);
                                    System.out.println("----------------------------------------" + i.getUdp() + "------------------------------------" + result);
                                }
                            } else {
                                inputdb.bulkInputUpdateByServer(server.get("serverip").toString(), instatus);
                            }
                        } else {
                            instatus = false;
                        }
                        outstatus = !server.get("output_eth").toString().equalsIgnoreCase("None") ? (server.get("remark").toString().equalsIgnoreCase("primary") ? LinuxCommandExecutor.interfaceStatus(server.get("output_eth").toString()) : InputStatus.secondaryInterfaceSatus(server.get("serverip").toString(), server.get("output_eth").toString())) : false;
                        if (Boolean.parseBoolean(server.get("in_status").toString()) != instatus) {
                            inputdb.updateInterfaceDetails(server.get("serverip").toString(), instatus, server.get("input_eth").toString());
                        }
                        if (Boolean.parseBoolean(server.get("out_status").toString()) == outstatus) continue;
                        inputdb.updateInterfaceDetails(server.get("serverip").toString(), outstatus, server.get("output_eth").toString());
                    }
                    catch (Exception e) {
                        System.out.println("Exception at reading interface status for secondary server: " + e.getMessage());
                    }
                }
            } else {
                System.out.println("normal client came");
                for (Input i : inputList) {
                    System.out.println("udp: " + i.getUdp());
                    boolean status = false;
                    String protocol = InputStatus.getProtocolType(i.getUdp());
                    System.out.println("protocol: " + protocol);
                    boolean issec = false;
                    if (i.getServer_ip() != null && !i.getServer_ip().equals("")) {
                        if (inputdb.isSecondary(i.getServer_ip())) {
                            status = InputStatus.secondaryInputStatus(path, protocol, i.getUdp(), i.getServer_ip());
                            issec = true;
                        } else {
                            status = InputStatus.primaryInputStatus(path, protocol, i.getUdp());
                            issec = false;
                        }
                    } else {
                        status = InputStatus.primaryInputStatus(path, protocol, i.getUdp());
                        issec = false;
                    }
                    inputdb.updateStreamInputStatus(i.getId(), status);
                    System.out.println("----------------------------------------finished------------------------------------" + status);
                }
            }
            Thread.sleep(2000L);
        }
    }

    public static String commandExe(String eth) {
        String response = "DOWN";
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "ip link show dev " + eth + " | grep -oP '(?<=state )\\w+'\n");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                response = line;
            }
        }
        catch (Exception e) {
            return "DOWN";
        }
        return response;
    }

    public static String getProtocolType(String udp) {
        try {
            if (udp.startsWith("udp")) {
                return "ip";
            }
            if (udp.startsWith("http")) {
                return "http";
            }
            return "ip";
        }
        catch (Exception e) {
            System.out.println("Exception at getting Protocol type: " + e.getMessage());
            return "";
        }
    }

    public static boolean primaryInputStatus(String path, String protocol, String udp) {
        System.out.println("reading primary input status");
        boolean status = false;
        String oldprotocol = "";
        String oldurl = "";
        String newurl = "";
        newurl = udp.substring(6, udp.length());
        try {
            File file = new File(path);
            Scanner scanner = new Scanner(file);
            String fileContents = "";
            while (scanner.hasNextLine()) {
                fileContents = fileContents + scanner.nextLine() + "\n";
            }
            String[] s = fileContents.split("\n");
            int a = 0;
            for (String ss : s) {
                if (ss.contains("PROTOCOL")) {
                    System.out.println(ss);
                    oldprotocol = ss;
                    oldprotocol = oldprotocol.substring(oldprotocol.lastIndexOf("=") + 1, oldprotocol.length());
                    System.out.println("oldpro: " + oldprotocol);
                }
                if (ss.contains("INPUT_URL")) {
                    System.out.println(ss);
                    oldurl = ss;
                    oldurl = oldurl.substring(oldurl.lastIndexOf("=") + 1, oldurl.length());
                    newurl = protocol.equals("ip") ? udp.substring(6, udp.length()) : (protocol.equals("http") ? udp : udp.substring(6, udp.length()));
                    System.out.println("oldurl: " + oldurl);
                }
                ++a;
            }
            scanner.close();
            fileContents = fileContents.replace(oldurl, "\"" + newurl + "\"");
            fileContents = fileContents.replace(oldprotocol, "\"" + protocol + "\"");
            System.out.println(fileContents);
            FileWriter writer = new FileWriter(file);
            writer.write(fileContents);
            writer.close();
            status = new LinuxCommandExecutor().scriptExe(path);
        }
        catch (Exception e) {
            System.out.println("Exception at primary: " + e);
        }
        return status;
    }

    public static boolean secondaryInputStatus(String path, String protocol, String udp, String server_ip) {
        boolean status;
        block15: {
            status = false;
            try {
                URL urL = new URL("http://" + server_ip + ":8000/getInputStatus");
                System.out.println("url--" + urL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                httpURLConnection.setDoOutput(true);
                OutputStream os = httpURLConnection.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                JSONObject obj = new JSONObject();
                obj.put((Object)"path", (Object)path);
                obj.put((Object)"protocol", (Object)protocol);
                obj.put((Object)"udp", (Object)udp);
                osw.write(obj.toJSONString());
                osw.flush();
                osw.close();
                String line = "false";
                if (httpURLConnection.getResponseCode() != 200) break block15;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    line = br.readLine();
                    System.out.println("line from server=" + line);
                }
                if (line.equalsIgnoreCase("true")) {
                    status = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    public static boolean secondaryInterfaceSatus(String server_ip, String eth) {
        boolean status;
        block15: {
            status = false;
            try {
                URL urL = new URL("http://" + server_ip + ":8000/interfaceStatus");
                System.out.println("url--" + urL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                httpURLConnection.setDoOutput(true);
                OutputStream os = httpURLConnection.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                JSONObject obj = new JSONObject();
                obj.put((Object)"eth", (Object)eth);
                osw.write(obj.toJSONString());
                osw.flush();
                osw.close();
                String line = "false";
                if (httpURLConnection.getResponseCode() != 200) break block15;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    line = br.readLine();
                    System.out.println("line from server=" + line);
                }
                if (line.equalsIgnoreCase("UP")) {
                    status = true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return status;
    }

    public static boolean inputReadForffprobe(String udp, int id, String server_ip, int streamcount) throws ClassNotFoundException {
        boolean status;
        block28: {
            inputdb.deleteTrackbyInputID(id);
            status = false;
            JSONArray Programs = new JSONArray();
            try {
                String json_string = "";
                if (!inputdb.isSecondary(server_ip)) {
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    processBuilder.command("bash", "-c", "timeout 30s ffprobe -v quiet -print_format json -show_programs " + udp);
                    Process process = processBuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        json_string = json_string + line;
                        status = true;
                    }
                } else {
                    URL urL = new URL("http://" + server_ip + ":8000/StreamExtracter");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                    httpURLConnection.setDoOutput(true);
                    OutputStream os = httpURLConnection.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"udp", (Object)udp);
                    osw.write(udp);
                    osw.flush();
                    osw.close();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    String line = "";
                    json_string = line = bufferedReader.readLine();
                    System.out.println("line from server" + line);
                    if (line != null) {
                        status = true;
                    }
                }
                System.out.println(json_string);
                if (json_string != null && !json_string.equals("")) {
                    inputdb.updateStreamInputStatus(id, true);
                } else {
                    inputdb.updateStreamInputStatus(id, false);
                }
                System.out.println(streamcount);
                if (streamcount != 0 || json_string == null || json_string.equals("")) break block28;
                JSONParser parser = new JSONParser();
                Object obj1 = parser.parse(json_string);
                JSONObject json_data = (JSONObject)obj1;
                try {
                    Programs = (JSONArray)json_data.get((Object)"programs");
                }
                catch (Exception e) {
                    System.out.println("No Programs");
                }
                for (int j = 0; j < Programs.size(); ++j) {
                    String service_name;
                    String provider = "";
                    JSONObject program = (JSONObject)Programs.get(j);
                    int program_num = Integer.parseInt(program.get((Object)"program_num").toString());
                    JSONObject service_obj = (JSONObject)program.get((Object)"tags");
                    try {
                        service_name = service_obj.get((Object)"service_name").toString();
                    }
                    catch (Exception e) {
                        service_name = "Unknown";
                    }
                    JSONArray Streams = (JSONArray)program.get((Object)"streams");
                    JSONObject tags = new JSONObject();
                    try {
                        tags = (JSONObject)program.get((Object)"tags");
                        provider = tags.get((Object)"service_provider").toString();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        provider = "No provider";
                    }
                    try {
                        for (int k = 0; k < Streams.size(); ++k) {
                            String language;
                            JSONObject stream = (JSONObject)Streams.get(k);
                            String codec_type = "";
                            try {
                                codec_type = stream.get((Object)"codec_type").toString();
                            }
                            catch (Exception e) {
                                codec_type = "No codec";
                            }
                            if (codec_type.contains("video") || codec_type.contains("no codec")) {
                                String v_codec = codec_type.contains("video") ? stream.get((Object)"codec_name").toString() : "no codec";
                                if (!inputdb.getCountByStreamNameProgramNoForUDP(service_name, id, program_num)) {
                                    inputdb.insertInputChannels(service_name, v_codec, program_num, id, provider);
                                } else {
                                    inputdb.updateInputStreamDetails(id, service_name, v_codec, program_num, provider);
                                }
                            }
                            if (!codec_type.contains("audio") && !codec_type.contains("no codec")) continue;
                            String a_codec = null;
                            String bitrate = null;
                            try {
                                if (codec_type.contains("audio")) {
                                    a_codec = stream.get((Object)"codec_name").toString();
                                    bitrate = stream.get((Object)"bit_rate").toString();
                                } else {
                                    a_codec = "no codec";
                                }
                                JSONObject stream_obj = (JSONObject)stream.get((Object)"tags");
                                language = stream_obj.get((Object)"language").toString();
                            }
                            catch (Exception e) {
                                language = "Default";
                                System.out.println("Exception at streams tag:" + e.getMessage());
                            }
                            if (bitrate == null || bitrate.equals("")) {
                                bitrate = "0";
                            }
                            inputdb.insertAudioTrack(language, a_codec, id, program_num, bitrate);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception at streams:" + e.getMessage());
                    }
                    inputdb.updateStreamInputStatuswithStreamCount(id, status, Programs.size());
                }
            }
            catch (Exception e) {
                status = false;
                System.out.println("Exception at trackextractor :" + e.getMessage());
            }
        }
        return status;
    }

    public static boolean isSPTS(String udp) {
        boolean status = true;
        JSONArray Programs = new JSONArray();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("bash", "-c", "timeout 30s ffprobe -v quiet -print_format json -show_programs -analyzeduration 100M -probesize 100M " + udp);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String json_string = "";
            String line = null;
            while ((line = reader.readLine()) != null) {
                json_string = json_string + line;
                status = true;
            }
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(json_string);
            JSONObject json_data = (JSONObject)obj;
            try {
                Programs = (JSONArray)json_data.get((Object)"programs");
            }
            catch (Exception e) {
                System.out.println("No Programs");
            }
            status = Programs.size() <= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    static {
        filePath = "/home/user/RIDSYSPACKAGE/riptv/live/INPUTSTATUS/dist/udpstatus.txt";
        client = "";
        inputdb = new InputDB();
    }
}

